//
// API for ATI Tray Tools
// C++ version
// (c) 2004,2005 Ray Adams
//
//
//
//
//

#define ATT_Sign 0x4154544C
        //Plugin type
#define        PL_STD 0       // standard plugin
#define        PL_RunTime 1   //Run Time plugin
#define        PL_OSD 2   //Run Time OSD plugin
#define        PL_MGO 3   //Monitoring Graphs Plugin //not implemented yet

#define         atc_getversion 1
        //Get ATT Version
        //inData = 0
        //outData pointer to word , hi byte - HI Version, low byte = Low version

#define        atc_getDriverRegKey 2
        //Get currect registry path for catalyst driver
        //inData=0
        //outData = PChar,
        //must be allocated in plugin and have enought space to store path, >=255 will be enought

#define        atc_IsLDInstalled 3
        //Check if low lever driver was installed
        //inData=0
        //outData = pointer to byte
        // 1 = yes
        // 2 = no

#define        atc_inb 4
#define        atc_inw 5
#define        atc_ind 6
        //read Byte/Word/Dword from port
        //inData = pointer to TPortIO port
        //outData = pointer to dword, result
#define        atc_outb 7
#define        atc_outw 8
#define        atc_outd 9
        //write Byte/Word/Dword to port
        //inData = pointer to TPortIO record
        //      port to write
        //      value to write
        //outData = pointer to dword, result

#define        atc_getPCIBusDataB 10
#define        atc_getPCIBusDataW 11
#define        atc_getPCIBusDataD 12

        //read Byte/Word/Dword from PCI registers
        //inData = pointer to TPCIIO record
        //     used only bus,device,func, offset
        //outData = pointer to dword, result

#define        atc_getClocks 13
        //read current clocks
        //inData = 0
        //outData = pointer to dword
        //hi part : memory
        //lo part : GPU

#define        atc_setClocks 14
        //set clocks. PLEASE BE CAREFUL!!!
        //inData = 0
        //outData = pointer to dword (4 bytes)
        //hi part : memory
        //lo part : GPU

#define        atc_ReadDefaultClocks 15
        //read default clocks from BIOS
        //inData = 0
        //outData = pointer to dword
        //hi part : memory
        //lo part : GPU
#define        atc_MapMemory 16
        //Map frame buffer from physical address space to linear
        //inData = pointer to TMemoryMapping
        //outData = pointer to dword (variable with address of mapped memory)
#define        atc_UnMapMemory 17
        //Unmap IO memory
        //inData = pointer to variable returned by atc_MapMemory
        //outData = 0
#define        atc_MRRReadB 18
        //Read byte from MMR
        //inData = pointer to word as offset in MMR
        //outDate = pointer to byte
#define        atc_MRRReadW 19
        //Read byte from MMR
        //inData = pointer to word as offset in MMR
        //outDate = pointer to word
#define        atc_MRRReadD 20
        //Read byte from MMR
        //inData = pointer to word as offset in MMR
        //outDate = pointer to dword
#define        atc_MRRWriteB 21
        //Writebyte from MMR
        //inData = pointer to word as offset in MMR
        //outDate = pointer to byte (value to write)
#define        atc_MRRWriteW 22
        //Write word to MMR
        //inData = pointer to word as offset in MMR
        //outDate = pointer to word (value to write)
#define        atc_MRRWriteD 23
        //Write dword to MMR
        //inData = pointer to word as offset in MMR
        //outDate = pointer to dword (value to write)

#define atc_setPCIBusDataB 24
#define atc_setPCIBusDataW 25
#define atc_setPCIBusDataD 26

        //write Byte/Word/Dword from PCI registers
        //inData = pointer to TPCIIO record
        //     used all values: bus,device,func, offset, value
        //outData = nothing

#define  atc_VIDBusDataB 27
#define  atc_VIDBusDataW 28
#define  atc_VIDBusDataD 29
        //Read registers from current video card
        //inData - register
        //outData - pointer to variable to receive value from registers


#define  atc_tmsupport 30
        //Read data from temperature sensore
        //inData - void
        //outData - pointer to TMonSuport struct

#define        atc_mbmsupported 31
        //inData none
        //outData TChipProperties
#define        atc_getmbm_source_name 32
        //inData - dword index of source
        // starting from tempretaures, next VoltagesCount and last RPMsCount (fans)
        // so first index is always 0
        // total indexes is VoltagesCount+TemperaturesCount+RPMsCount
        //outData PChar is name of source
#define        atc_getmbm_source_val 33
        //inData - index (same as above)
        //outData - pointer to float

#define		   atc_getmsr 34
        //inData - dword MSR Register
        //outData - pointer to int64

#define atc_readi2c 35  
	//Read I2C (Only for X1xxx and up boards yet)
        //inData - pointer to ReadI2C struct
        //outData - pointer to byte

#define atc_load2d 36
	//Load default 2D Overclocking profile

#define atc_load3d 37
	//Load default 3D Overclocking profile

typedef struct tagReadI2C {
       DWORD I2CBus;
       DWORD I2CAddr;
       DWORD I2CRegister;
       DWORD I2CReadStatus; // ATT write here a status of operation
} ReadI2C, *PReadI2C



typedef struct tagtmbmChipProp {
    DWORD isSupported;
    DWORD VoltagesCount;
    DWORD Presets;
    DWORD TemperaturesCount;
    DWORD RPMsCount;
    DWORD PWMsCount;
} mbmChipProp, *PmbmChipProp;


typedef struct tagTPortIO {
         UINT port;
         DWORD value;
} TPortIO, *PPortIO;

typedef struct tagTPCIIO {
         char bus,device,func,offset;
         DWORD value;
} TPCIIO, *PPCIIO;

typedef struct tagTPlugInfo {
         DWORD Sign;    //std 4 chars to identify itself as a ATT plugin
         char Menu_Text[51]; // text for menu
         char PluginType; //type of plugin reserved must be PL_STD
} TPlugInfo, *PPlugInfo;

typedef struct tagMemoryMapping {
         DWORD addr; //address of memory for mapping
         DWORD size; //size of memory to map
} TMemoryMapping, *PMemoryMapping;

typedef struct tagTMonSuport {
        DWORD SensorSupported;//0 if not supported
        char SensorName[10]; //sensor name
        DWORD TempGpu;
        DWORD TempEnv;
        DWORD FanDuty;

} TMonSuport, *PMonSuport;

typedef void (STDAPICALLTYPE*  lppget_plug_info)(PPlugInfo Data);
typedef void (STDAPICALLTYPE*  lppatt_proc)(UINT ACommand, void* inData, void* outData);
typedef void (STDAPICALLTYPE*  lppexec_plugin)(HWND Win_Handle, void* ATT_Proc);

//////////////////////////////////
//Only for Run Time plugins
//ATT Will execute this function before terminate.
//////////////////////////////////
typedef void (STDAPICALLTYPE*  lppdone_plugin)();

//////////////////////////////////
//ATT will execute this function after resuming from suspend/hibernate mode
//Plug-In must decide what to do at this time.
//if your plugin has no actions to be implemented after suspend mode create dummy procedure
//////////////////////////////////
typedef void (STDAPICALLTYPE*  lppsuspend_restore)();

//////////////////////////////////
//Run Configuration for plugin
//////////////////////////////////
typedef void (STDAPICALLTYPE*  lppconfig_plugin)(HWND Win_Handle, lppatt_proc ATT_Proc);

/////////////////////////////////
// Only for OSD Plugins
/////////////////////////////////
typedef void (STDAPICALLTYPE*  lppget_osd_string)(char* osd_string);


/////////////////////////////////
// Only for MGP Plugins
/////////////////////////////////
typedef void (STDAPICALLTYPE*  lppstart_mr_plugin)();
// Start monitoring plugin
//plugins should make any initializations here

typedef int (STDAPICALLTYPE*  lppget_mr_count)();
// Return count of monitoring sources supported

typedef void (STDAPICALLTYPE*  lppget_mr_name)(int source_index, char* source_name);
// Return name of monitoring source by index (source_index)

typedef float (STDAPICALLTYPE*  lppget_mr_value)(int source_index);
// Return current value for source by index

typedef DWORD (STDAPICALLTYPE*  lppget_mr_status)(int source_index);
// Return current status of monitroing source 1-enabled, 0-disabled


